/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import net.minecraft.class_9793;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.extensions.component.SophisticatedMutableDataComponentHolder;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ComponentItemHandler;

public class JukeboxUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType<Wrapper>(Wrapper::new);

    public JukeboxUpgradeItem(IUpgradeCountLimitConfig upgradeTypeLimitConfig) {
        super(upgradeTypeLimitConfig);
    }

    @Override
    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    @Override
    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return List.of();
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, JukeboxUpgradeItem>
    implements ITickableUpgrade {
        private static final int KEEP_ALIVE_SEND_INTERVAL = 5;
        private final ComponentItemHandler discInventory;
        private long lastKeepAliveSendTime = 0L;
        private boolean isPlaying;

        protected Wrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler);
            this.discInventory = new ComponentItemHandler((SophisticatedMutableDataComponentHolder)upgrade, class_9334.field_49622, 1){

                @Override
                protected void onContentsChanged(int slot, class_1799 oldStack, class_1799 newStack) {
                    super.onContentsChanged(slot, oldStack, newStack);
                    this.save();
                }

                @Override
                public boolean isItemValid(int slot, class_1799 stack) {
                    return stack.method_7960() || stack.method_57826(class_9334.field_52175);
                }
            };
            this.isPlaying = (Boolean)upgrade.sophisticatedCore_getOrDefault(ModCoreDataComponents.IS_PLAYING, (Object)false);
        }

        public void setDisc(class_1799 disc) {
            this.discInventory.setStackInSlot(0, disc);
        }

        public class_1799 getDisc() {
            return this.discInventory.getStackInSlot(0);
        }

        public void play(class_1937 level, class_2338 pos) {
            this.play(level, (class_3218 serverLevel, UUID storageUuid) -> class_9793.method_60753((class_7225.class_7874)level.method_30349(), (class_1799)this.getDisc()).ifPresent(song -> ServerStorageSoundHandler.startPlayingDisc(serverLevel, pos, storageUuid, this.getDisc(), (class_6880<class_9793>)song, () -> this.setIsPlaying(false))));
        }

        public void play(class_1297 entity) {
            this.play(entity.method_37908(), (class_3218 world, UUID storageUuid) -> class_9793.method_60753((class_7225.class_7874)entity.method_37908().method_30349(), (class_1799)this.getDisc()).ifPresent(song -> ServerStorageSoundHandler.startPlayingDisc(world, entity.method_19538(), storageUuid, entity.method_5628(), this.getDisc(), (class_6880<class_9793>)song, () -> this.setIsPlaying(false))));
        }

        private void play(class_1937 level, BiConsumer<class_3218, UUID> play) {
            if (!(level instanceof class_3218) || this.getDisc().method_7960()) {
                return;
            }
            this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> play.accept((class_3218)level, (UUID)storageUuid));
            this.setIsPlaying(true);
        }

        private void setIsPlaying(boolean playing) {
            this.isPlaying = playing;
            this.upgrade.sophisticatedCore_set(ModCoreDataComponents.IS_PLAYING, (Object)playing);
            if (this.isPlaying) {
                this.storageWrapper.getRenderInfo().setUpgradeRenderData(JukeboxUpgradeRenderData.TYPE, new JukeboxUpgradeRenderData(true));
            } else {
                this.removeRenderData();
            }
            this.save();
        }

        private void removeRenderData() {
            this.storageWrapper.getRenderInfo().removeUpgradeRenderData(JukeboxUpgradeRenderData.TYPE);
        }

        public void stop(class_1309 entity) {
            class_1937 class_19372 = entity.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                return;
            }
            class_3218 serverLevel = (class_3218)class_19372;
            this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.stopPlayingDisc((class_1937)serverLevel, entity.method_19538(), storageUuid));
            this.setIsPlaying(false);
        }

        public SlottedStackStorage getDiscInventory() {
            return this.discInventory;
        }

        @Override
        public void tick(@Nullable class_1297 entity, class_1937 level, class_2338 pos) {
            if (this.isPlaying && this.lastKeepAliveSendTime < level.method_8510() - 5L) {
                this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.updateKeepAlive(storageUuid, level, entity != null ? entity.method_19538() : class_243.method_24953((class_2382)pos), () -> this.setIsPlaying(false)));
                this.lastKeepAliveSendTime = level.method_8510();
            }
        }

        public boolean isPlaying() {
            return this.isPlaying;
        }

        @Override
        public void onBeforeRemoved() {
            this.removeRenderData();
        }
    }
}

